<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->string('vat_number')->nullable();
            $table->boolean('elengent_search')->default(false);
            $table->boolean('item_based_tax')->default(false);
            $table->boolean('item_consumption_mode')->default(true);
            $table->boolean('autoclose_service_table_model')->default(false);
            $table->boolean('autoclose_pickup_model')->default(false);
            $table->boolean('autoclose_customer_model')->default(false);
            $table->boolean('autoclose_shipping_model')->default(false);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->string('vat_number');
            $table->dropColumn('elengent_search');
            $table->dropColumn('item_consumption_mode');
            $table->dropColumn('item_based_tax');
            $table->dropColumn('autoclose_service_table_model');
            $table->dropColumn('autoclose_pickup_model');
            $table->dropColumn('autoclose_customer_model');
            $table->dropColumn('autoclose_shipping_model');
        });
    }
};
