<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('guest_room_reservations', function (Blueprint $table) {
            $table->id();
            $table->string('uuid');
            $table->string('tracking');
            $table->boolean('payment_cleared')->default(false);
            $table->text('note')->nullable();
            $table->text('staff_note')->nullable();
            $table->text('tax');
            $table->float('tax_amount')->default(0);
            $table->float('total_room_service_charges')->default(0);
            $table->longText('payments')->nullable();
            $table->timestamp('booked_at')->nullable();
            $table->string('reserved_at_date')->nullable();
            $table->string('reserved_at_time')->nullable();
            $table->string('reserved_till_date')->nullable();
            $table->string('reserved_till_time')->nullable();
            $table->unsignedBigInteger('reservation_status_id')->nullable();
            $table->unsignedBigInteger('booking_source_id')->nullable();
            $table->unsignedBigInteger('guest_room_id')->nullable();
            $table->unsignedBigInteger('customer_id')->nullable();
            $table->timestamp('checkin_at')->nullable();
            $table->timestamp('checkout_at')->nullable();

            $table->string('reservation_hours')->default(0);
            $table->string('per_hour_charges')->default(0);
            $table->string('sub_total')->default(0);

            $table->timestamps();

            $table->foreign('reservation_status_id')->references('id')->on('reservation_statuses');
            $table->foreign('booking_source_id')->references('id')->on('booking_sources');
            $table->foreign('guest_room_id')->references('id')->on('guest_rooms');
            $table->foreign('customer_id')->references('id')->on('customers');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('guest_room_reservations');
    }
};
