<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('guest_rooms', function (Blueprint $table) {
            $table->id();
            $table->string('room_name');
            $table->string('capactity')->default(1);
            $table->string('per_hour_charges')->default(0);
            $table->text('layout')->nullable();
            $table->boolean('availability')->default(1);
            $table->text('images')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('guest_rooms');
    }
};
