<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class GuestRoom extends Model
{
    protected $fillable = ['room_name', 'capactity', 'layout', 'availability', 'per_hour_charges'];

    public function reservations(): HasMany
    {
        return $this->hasMany(GuestRoomReservation::class, 'guest_room_id');
    }


    public function guestRoomReservations(): HasMany
    {
        return $this->hasMany(GuestRoomReservation::class, 'guest_room_id');
    }
}
