<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class UserActivityLogFilter extends ModelFilter
{

    public $relations = [];

    public function search($search): UserActivityLogFilter
    {
        $searchPattern = config('app.modes.elengent_search') ? $search . '%' : '%' . $search . '%';
        return $this->where('activity',  'LIKE', $searchPattern)
            ->orWhere('ip',  'LIKE', $searchPattern)
            ->orWhere('device',  'LIKE', $searchPattern)
            ->orWhere('link',  'LIKE', $searchPattern);
    }

    public function user($user): UserActivityLogFilter
    {
        return $this->where('user_id', $user);
    }
}
