<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class SaleItemFilter extends ModelFilter
{
    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    /**
     * Searches for the first match.
     *
     * @param      string         $search  The search
     *
     * @return     SaleItemFilter  The product filter.
     */
    public function search($search): SaleItemFilter
    {
        $searchPattern = config('app.modes.elengent_search') ? $search . '%' : '%' . $search . '%';
        return $this->where('item_name',  'LIKE', $searchPattern);
    }

    /**
     * Filtter by category
     *
     * @param      string       $category  The category
     *
     * @return     SaleItemFilter  The product filter.
     */
    public function category($category): SaleItemFilter
    {
        return $this->where('food_category_id', $category);
    }
}
