<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class SaleFilter extends ModelFilter
{
    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    /**
     * User dataTable search query
     *
     * @param mixed $search query
     *
     * @return SaleFilter
     */
    public function search($search): SaleFilter
    {
        $searchPattern = config('app.modes.elengent_search') ? $search . '%' : '%' . $search . '%';
        return $this->where('tracking', 'LIKE', $searchPattern);
    }


    public function biller($biller): SaleFilter
    {
        return $this->where('biller_id', '=', $biller);
    }

    public function customer($customer): SaleFilter
    {
        return $this->where('customer_id', '=', $customer);
    }

    public function chef($chef): SaleFilter
    {
        return $this->where('chef_id', '=', $chef);
    }

    public function paymentMethod($paymentMethod): SaleFilter
    {
        return $this->where('payment_method_id', $paymentMethod);
    }

    public function taker($taker): SaleFilter
    {
        return $this->where('order_taker_id', '=', $taker);
    }

    public function table($table): SaleFilter
    {
        return $this->where('table_id', '=', $table);
    }

    public function orderType($type): SaleFilter
    {
        return $this->where('order_type', '=', $type);
    }
}
