<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class ExpenseFilter extends ModelFilter
{
    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    /**
     * Searches for the first match.
     *
     * @param      string         $search  The search
     *
     * @return     ExpenseFilter  The product filter.
     */
    public function search($search): ExpenseFilter
    {
        $searchPattern = config('app.modes.elengent_search') ? $search . '%' : '%' . $search . '%';

        return $this->where('title',  'LIKE', $searchPattern)
            ->orWhere('amount',  'LIKE', $searchPattern);
    }

    /**
     * Filtter by category
     *
     * @param      string       $category  The category
     *
     * @return     ExpenseFilter  The product filter.
     */
    public function category($category): ExpenseFilter
    {
        return $this->where('expense_type_id', $category);
    }
}
