<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class CustomerFilter extends ModelFilter
{
    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    /**
     * Searches for the first match.
     *
     * @param      string           $search  The search
     *
     * @return     WarehouseFilter  The warehouse filter.
     */
    public function search($search): CustomerFilter
    {
        $searchPattern = config('app.modes.elengent_search') ? $search . '%' : '%' . $search . '%';
        return $this->where('name',  'LIKE', $searchPattern)
            ->orWhere('email',  'LIKE', $searchPattern)
            ->orWhere('phone',  'LIKE', $searchPattern)
            ->orWhere('address',  'LIKE', $searchPattern);
    }
}
