<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class CashBookFilter extends ModelFilter
{
    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    /**
     * Searches for the first match.
     *
     * @param      string          $search  The search
     *
     * @return     CashBookFilter  The cash book filter.
     */
    public function search($search): CashBookFilter
    {
        $searchPattern = config('app.modes.elengent_search') ? $search . '%' : '%' . $search . '%';
        return $this->where('name', 'LIKE', $searchPattern);
    }
}
