<?php

namespace App\Models;

use App\Traits\DurationScopeTrait;
use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Expense extends Model
{
    use HasFactory, Filterable, DurationScopeTrait;

    protected $fillable = ['cash_book_id', 'title', 'amount', 'expense_type_id', 'description', 'expense_date'];

    /**
     * Product category
     *
     * @return     BelongsTo  The belongs to.
     */
    public function expenseType(): BelongsTo
    {
        return $this->belongsTo(ExpenseType::class);
    }
}
