<?php

namespace App\Imports;

use App\Models\ReservationStatus;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;

class ReservationStatusesImport implements ToModel, WithHeadingRow, WithValidation
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        return new ReservationStatus([
            'title' => $row['title'],
        ]);
    }

    public function rules(): array
    {
        return [
            'title' => 'required|unique:reservation_statuses,title',
        ];
    }
}
