<?php

namespace App\Imports;

use App\Models\Modifier;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;

class ModifiersImport implements ToModel, WithHeadingRow, WithValidation
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        return new Modifier([
            'title' => $row['title'],
            'price' => $row['price'],
            'cost' => $row['cost'],
            'food_category_id' => $row['food_category_id'],
        ]);
    }

    public function rules(): array
    {
        return [
            'title' => 'required|unique:modifiers,title',
            'price' => 'required|numeric',
            'cost' => 'required',
            'food_category_id' => 'required|exists:food_categories,id',
        ];
    }
}
