<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PrintGuestRoomReservationDetailsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'tracking' => $this->tracking,
            'customer' => new CustomerResource($this->customer),
            'customer_id' => $this->customer_id,
            'booking_source' => new BookingSourceResource($this->bookingSource),
            'booking_source_id' => $this->booking_source_id,
            'reservation_status' => new ReservationStatusResource($this->reservationStatus),
            'reservation_status_id' => $this->reservation_status_id,
            'guest_room' => new GuestRoomResource($this->guestRoom),
            'guest_room_id' => $this->guest_room_id,
            'payment_cleared' => $this->payment_cleared,
            'tax_amount' => $this->tax_amount,
            'note' => $this->note,
            'staff_note' => $this->staff_note,
            'total_room_service_charges' => $this->total_room_service_charges,
            'reserved_at_date' => $this->reserved_at_date,
            'reserved_at_time' => $this->reserved_at_time,
            'reserved_till_date' => $this->reserved_till_date,
            'reserved_till_time' => $this->reserved_till_time,
            'tax' => $this->tax,

            'reservation_hours' => $this->reservation_hours,
            'sub_total' => $this->sub_total,
            'checkin_at' => $this->checkin_at,
            'sales_tax_amount' => $this->getSalesTaxAmount(),
            'sale_discount_amount' => $this->getSalesDiscountAmount(),
            'sales_payable_amount' => $this->getSalesPayableAmount(),
            'sales_items' => $this->getSalesItems(),
            'sales_orders' => $this->getSalesOrders(),
            'orders' => ReservationSaleDetailResource::collection($this->sales),
            'payments' => $this->payments ?? [],
            'payment_status' => $this->payment_cleared,
            'checkout_at' => $this->checkout_at,
            'created_at' => $this->updated_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
