<?php

namespace App\Http\Resources;

use App\Http\Resources\PosModifierResource;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\PosFoodItemAttributeDetailResource;

class PosFoodItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {

        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'category_id' => $this->category_id,
            'name' => $this->name,
            'image' => $this->getImage(),
            'sku' => $this->sku,
            'cost' => $this->cost,
            'price' => $this->price,
            'food_item_id' => null,
            'modifiers' => PosModifierResource::collection($this->getModifiers()),
            'is_bar_type' => $this->is_bar_type,
            //'in_stock' => $this->getTotalInStock(),
            'description' => $this->description,
            'in_stock' => 200,
            'has_variants' => $this->has_variants,
            'tax_setup' => new TaxResource($this->getTaxSetup()),
            'variants' => PosFoodItemAttributeDetailResource::collection($this->foodItemAttributes),
        ];
    }
}
