<?php

namespace App\Http\Resources;


use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class GuestRoomReservationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'tracking' => $this->tracking,
            'customer' => new CustomerResource($this->customer),
            'booking_source' => new BookingSourceResource($this->bookingSource),
            'reservation_status' => new ReservationStatusResource($this->reservationStatus),
            'guest_room' => new GuestRoomResource($this->guestRoom),
            'payment_cleared' => $this->payment_cleared,
            'tax_amount' => $this->tax_amount,
            'total_room_service_charges' => $this->total_room_service_charges,
            'reserved_at_date' => $this->reserved_at_date,
            'reserved_at_time' => $this->reserved_at_time,
            'checkin_at' => $this->checkin_at,
            'checkout_at' => $this->checkout_at,
            'reservation_hours' => $this->reservation_hours,
            'sub_total' => $this->sub_total,
            'created_at' => $this->updated_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),

        ];
    }
}
