<?php

namespace App\Http\Resources;

use App\Http\Resources\FoodCategoryResource;
use Illuminate\Http\Resources\Json\JsonResource;

class FoodItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'sku' => $this->sku,
            'name' => $this->name,
            'cost' => $this->cost,
            'price' => $this->price,
            'is_bar_type' => $this->is_bar_type,
            'has_variants' => $this->has_variants,
            'variants' => count($this->foodItemAttributes),
            'image' => $this->getImage(),
            'category' => new FoodCategoryResource($this->category),
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
