<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ModifierStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|unique:modifiers',
            'price' => 'required|numeric|gte:cost',
            'cost' => 'required',
            'ingredients' => 'sometimes|array',
            'food_category_id' => 'required',
        ];
    }

    public function messages(): array
    {
        return [
            'price.gte' => __('Price must be equal or greater then cost'),
        ];
    }
}
