<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Api\SettingController;
use App\Http\Requests\SettingAdvanceRequest;
use App\Http\Requests\SettingAuthenticationRequest;
use App\Http\Requests\SettingCaptchaRequest;
use App\Http\Requests\SettingCurrencyRequest;
use App\Http\Requests\SettingOutgoingMailRequest;
use App\Http\Requests\SettingPrinterRequest;
use App\Http\Requests\SettingTaxRequest;
use App\Http\Requests\SettingTemplatesRequest;
use Illuminate\Http\JsonResponse;


class SettingAxillaryController extends SettingController
{

    public function __construct()
    {
        $this->middleware('auth:sanctum');
        $this->middleware('demo')->only(
            [
                'getAuthentication',
                'setOutgoingMail',
                'setLogging',
                'setCaptcha',
                'setCurrency',
                'setTax',
                //'setAdvance',
                'setPrinter',
            ]
        );
        $this->settings = $this->master();
        $this->collection = collect($this->settings);
    }


    public function getAuthentication(): JsonResponse
    {
        return response()->json(
            $this->collection->only(
                [
                    'app_user_registration',
                    'app_default_role',
                ]
            )
        );
    }


    public function setAuthentication(SettingAuthenticationRequest $request): JsonResponse
    {
        $this->settings->update($request->validated());
        \App\Helpers\ActivityLogger::log(__('Authentication settings updated successfully'));
        return response()->json(
            ['message' => __('Settings updated successfully')]
        );
    }

    /**
     * Gets the outgoing mail.
     *
     * @return JsonResponse  The outgoing mail.
     */
    public function getOutgoingMail(): JsonResponse
    {
        return response()->json(
            [
                'data' => $this->collection->only(
                    [
                        'mail_from_address',
                        'mail_from_name',
                        'mail_mailer',
                        'mail_encryption',
                        'mail_host',
                        'mail_password',
                        'mail_port',
                        'mail_username',
                        'mailgun_domain',
                        'mailgun_secret',
                        'mailgun_endpoint',
                        'queue_connection',
                    ]
                ),
                'command_1' => '/usr/local/bin/php  ' . base_path() . '/artisan schedule:run >> /dev/null',
                'command_2' => '/usr/bin/php  ' . base_path() . '/artisan schedule:run >> /dev/null',
            ]
        );
    }


    public function setOutgoingMail(SettingOutgoingMailRequest $outgoingMail): JsonResponse
    {
        $this->settings->update($outgoingMail->validated());
        \App\Helpers\ActivityLogger::log(__('Outgoing mail settings updated successfully'));
        return response()->json(
            ['message' => __('Settings updated successfully')]
        );
    }


    public function getCaptcha(): JsonResponse
    {
        return response()->json(
            $this->collection->only(
                [
                    'recaptcha_enabled',
                    'recaptcha_public',
                    'recaptcha_private',
                ]
            )
        );
    }


    public function setCaptcha(SettingCaptchaRequest $captcha): JsonResponse
    {
        $this->settings->update($captcha->validated());
        \App\Helpers\ActivityLogger::log(__('Google captcha settings updated successfully'));
        return response()->json(
            ['message' => __('Settings updated successfully')]
        );
    }


    public function getTax(): JsonResponse
    {
        return response()->json(
            $this->collection->only(
                [
                    'tax_rate',
                    'is_tax_fix',
                    'is_tax_included',
                    'tax_id',
                    'is_vat',
                    'tax_title',
                    'vat_number',
                ]
            )
        );
    }


    public function setTax(SettingTaxRequest $tax): JsonResponse
    {
        $this->settings->update($tax->validated());
        \App\Helpers\ActivityLogger::log(__('Tax settings updated successfully'));
        return response()->json(
            ['message' => __('Settings updated successfully')]
        );
    }


    public function getCurrency(): JsonResponse
    {
        return response()->json(
            $this->collection->only(
                [
                    'currency_symbol_on_left',
                    'currency_symbol',
                ]
            )
        );
    }


    public function setCurrency(SettingCurrencyRequest $currency): JsonResponse
    {
        $this->settings->update($currency->validated());
        \App\Helpers\ActivityLogger::log(__('Currency settings updated successfully'));
        return response()->json(
            ['message' => __('Settings updated successfully')]
        );
    }

    public function getPrinter(): JsonResponse
    {
        return response()->json(
            $this->collection->only(
                [
                    'print_font_family',
                    'print_name_address_position',
                    'print_name_address_size',
                    'print_header_footer_size',
                    'print_items_font_size',
                    'print_terms_conditions_font_size',
                    'print_font_color',
                    'printer_width',
                    'printer_height',
                    'signature_required',
                    'terms_conditions',
                    'print_auto',
                    'invoice_type_title',
                    'display_logo',

                ]
            )
        );
    }


    public function setPrinter(SettingPrinterRequest $currency): JsonResponse
    {
        $this->settings->update($currency->validated());
        \App\Helpers\ActivityLogger::log(__('Printing settings updated successfully'));
        return response()->json(
            ['message' => __('Settings updated successfully')]
        );
    }

    public function getAdvance(): JsonResponse
    {
        return response()->json(
            $this->collection->only(
                [
                    'advance_cashbook_mode',
                    'advance_print_on_submit',
                    'advance_customer_tip_collection',
                    'advance_send_notification',
                    'bypass_kitchen_bar',
                    'allow_table_reselect',
                    'table_is_option',
                    'allow_to_edit_checked_orders',
                    'disable_room_reservations',
                    'elengent_search',
                    'item_consumption_mode',
                    'item_based_tax',
                    'autoclose_service_table_model',
                    'autoclose_pickup_model',
                    'autoclose_customer_model',
                    'autoclose_shipping_model',
                    'taxation',
                    'digital_menu'
                ]
            )
        );
    }


    public function setAdvance(SettingAdvanceRequest $currency): JsonResponse
    {
        $this->settings->update($currency->validated());
        \App\Helpers\ActivityLogger::log(__('Printing settings updated successfully'));
        return response()->json(
            ['message' => __('Settings updated successfully')]
        );
    }


    /**
     * Gets the terms.
     *
     * @return     JsonResponse  The terms.
     */
    public function getTemplates(): JsonResponse
    {
        return response()->json(
            $this->collection->only([
                'template_order_created',
                'template_order_cancelled',
                'template_order_checkout',
            ])
        );
    }

    /**
     * Sets the terms.
     *
     * @param      \App\Http\Requests\SettingTermsRequest  $terms  The terms
     *
     * @return     JsonResponse                            The json response.
     */
    public function setTemplates(SettingTemplatesRequest $terms): JsonResponse
    {
        $this->settings->update($terms->validated());
        return response()->json(
            ['message' => __('Settings updated successfully')]
        );
    }
}
