<?php
session_start();

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;
use Dotenv\Dotenv;

require 'vendor/autoload.php';



$dotenv = Dotenv::createImmutable(__DIR__);
$dotenv->load();

if (isset($_POST['submitPatient'])) {
    $fullname = $_POST['full_name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $datetime = $_POST['datetime'];
    $service = $_POST['services'];
    $doctor = $_POST['doctor'];





    //Create an instance; passing `true` enables exceptions
    $mail = new PHPMailer(true);


    //Server settings
    // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
    $mail->isSMTP();
    $mail->SMTPDebug = SMTP::DEBUG_SERVER;
    $mail->Host = $_ENV['SMTP_HOST'];
    $mail->Port = $_ENV['SMTP_PORT'];
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;            //ENCRYPTION_SMTPS 465 - Enable implicit TLS encryption
    $mail->SMTPAuth = true;                                   //Enable SMTP authentication	

    $mail->Username = $_ENV['SMTP_USER'];                     //SMTP username
    $mail->Password = $_ENV['SMTP_PASS'];                               //SMTP password

    //Recipients
    $mail->setFrom($_ENV['SMTP_USER'], 'WEB SITE');
    // $mail->addReplyTo($_ENV['SMTP_USER'], 'JOHN DOE');
    $mail->addAddress('reception@mecchealth.com', 'The MEC Team');     //Add a 
    $mail->Subject = 'New appointment Request - MEC Contact Form';

    //Content
    $mail->isHTML(true);                                  //Set email format to HTML


    $bodyContent = '<div>Hello, you got a new appointment enquiry</div>
            <div>Fullname: ' . $fullname . '</div>
            <div>Email: ' . $email . '</div>
            <div>Phone: ' . $phone . '</div>
            <div>Service: ' . $service . '</div>
            <div>Doctor: ' . $doctor . '</div>
            <div>Date & Time: ' . $datetime . '</div>
        ';

    $mail->Body = $bodyContent;


    if (!$mail->send()) {
        $_SESSION['status'] = 'Mailer Error: ' . $mail->ErrorInfo;
    } else {
        $_SESSION['status'] = 'Thank you for booking your appointment - The MEC Team';
    }

    // Redirect back to the form
    header("Location: {$_SERVER['HTTP_REFERER']}");
    exit;
}
